﻿//////////////////////////////////////////////
// TextureCopyProgramTracker.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkAstraeus
#include "../../Utils/ProgramTracker.h"

#include "TextureCopyEffectInfo.h"

/// Internals --------------------------------

namespace nkAstraeus
{
	struct TextureCopyProgramIdGenerator
	{
		static unsigned long long generate (const TextureCopyEffectInfo& info) ;
	} ;

	struct TextureCopyProgramNameGenerator
	{
		constexpr static const char* name = "NILKINS_TEX_COPY_PROGRAM_" ;
	} ;
}

/// Class ------------------------------------

namespace nkAstraeus
{
	class TextureCopyProgramTracker final : public ProgramTracker<TextureCopyEffectInfo, TextureCopyProgramIdGenerator, TextureCopyProgramNameGenerator>
	{
		public :

			// Functions
			// Constructor, destructor
			TextureCopyProgramTracker (nkGraphics::System* graphicsSystem) noexcept ;
			virtual ~TextureCopyProgramTracker () ;
	} ;
}